// מצב הסרגל - מוסתר או מוצג
let isSidebarHidden = false;
let styleElement = null;

// פונקציה ליצירת כפתור ההסתרה
function createToggleButton() {
  console.log('משנת יוסף: יוצר כפתור הסתרה');
  
  // יצירת style element להרחבת המסך
  if (!styleElement) {
    styleElement = document.createElement('style');
    styleElement.id = 'mishnat-yosef-expand-style';
    document.head.appendChild(styleElement);
  }
  
  // יצירת הכפתור
  const button = document.createElement('button');
  button.id = 'mishnat-yosef-toggle-btn';
  button.innerHTML = '◀'; // חץ שמאלה
  button.title = 'הסתר/הצג סרגל צדדי';
  
  // הוספת הכפתור לדף
  document.body.appendChild(button);
  console.log('משנת יוסף: כפתור נוסף לדף');
  
  // הוספת מאזין ללחיצה
  button.addEventListener('click', toggleSidebar);
}

// פונקציה להסתרה/הצגה של הסרגל
function toggleSidebar() {
  // ניסיון למצוא את הסרגל עם כמה סלקטורים שונים
  let sidebar = document.querySelector('.flex.flex-grow.flex-col.bg-primary-900.overflow-hidden');
  
  // אם לא נמצא, ננסה סלקטור אלטרנטיבי
  if (!sidebar) {
    sidebar = document.querySelector('div.bg-primary-900');
  }
  
  // מציאת הסרגל הנוסף
  const extraSidebar = document.querySelector('.md\\:fixed.md\\:inset-y-0.md\\:flex.md\\:w-\\[196px\\]');
  
  // עוטף שמוסיף padding-ימני לתוכן
  const paddingWrapper = document.querySelector('.md\\:pr-\\[196px\\], .pr-\\[196px\\]');
  
  const button = document.getElementById('mishnat-yosef-toggle-btn');
  
  if (!sidebar) {
    console.warn('משנת יוסף: לא נמצא סרגל צדדי');
    alert('לא נמצא סרגל צדדי. פתח את Console (F12) לפרטים.');
    return;
  }
  
  // מציאת המיכל הראשי והתוכן הראשי
  const mainContainer = sidebar.parentElement;
  const mainContent = mainContainer ? mainContainer.querySelector('main, div[class*="main"], div:not(.flex-grow)') : null;
  
  console.log('משנת יוסף: מחליף מצב סרגל', { sidebar, extraSidebar, paddingWrapper });
  if (extraSidebar) {
    console.log('משנת יוסף: מצאתי גם סרגל נוסף', extraSidebar);
  }
  
  if (isSidebarHidden) {
    // הצגת הסרגל
    sidebar.style.display = '';
    if (extraSidebar) {
      extraSidebar.style.display = '';
    }
    if (paddingWrapper) {
      paddingWrapper.style.paddingRight = '';
    }
    button.innerHTML = '◀';
    button.title = 'הסתר סרגל צדדי';
    isSidebarHidden = false;
    
    // הסרת CSS של הרחבה
    styleElement.textContent = '';
    
    // החזרת רוחב רגיל לתוכן
    if (mainContainer) {
      mainContainer.style.marginRight = '';
      mainContainer.style.paddingRight = '';
      mainContainer.style.width = '';
    }
    if (mainContent) {
      mainContent.style.maxWidth = '';
      mainContent.style.width = '';
    }
  } else {
    // הסתרת הסרגל
    sidebar.style.display = 'none';
    if (extraSidebar) {
      extraSidebar.style.display = 'none';
    }
    if (paddingWrapper) {
      paddingWrapper.style.paddingRight = '0';
    }
    button.innerHTML = '▶';
    button.title = 'הצג סרגל צדדי';
    isSidebarHidden = true;
    
    // הוספת CSS להרחבת המסך
    styleElement.textContent = `
      /* הרחבת כל המיכלים */
      body, html {
        overflow-x: hidden !important;
      }
      
      body > div,
      body > main,
      main,
      [role="main"],
      .main-content,
      div[class*="container"],
      div[class*="wrapper"],
      div[class*="content"] {
        max-width: 100% !important;
        width: 100% !important;
        margin-left: 0 !important;
        margin-right: 0 !important;
        padding-left: 20px !important;
        padding-right: 20px !important;
      }
      
      /* ביטול padding של העוטף עם המחלקה הפרטית */
      .md\\:pr-\\[196px\\], .pr-\\[196px\\] {
        padding-right: 0 !important;
      }

      /* ביטול margin-right של מחלקות קבועות */
      .md\\:mr-\\[196px\\], .mr-\\[196px\\] {
        margin-right: 0 !important;
      }

      /* ליתר ביטחון: אלמנטים עם רוחב 196px בצד כמגירת צד */
      .md\\:w-\\[196px\\] {
        width: 0 !important;
        display: none !important;
      }

      /* הרחבת סרגל עליון שמוגבל ע"י xl:w-[calc(100%-196px)] */
      .xl\\:w-\\[calc\\(100\\%-196px\\)\\] {
        width: 100% !important;
      }
      /* גרסה כללית באמצעות סלקטור לפי מחרוזת בכיתה */
      [class*="xl:w-[calc(100%-196px)]"] {
        width: 100% !important;
      }
      
      /* הסרת כל הגבלות רוחב */
      * {
        max-width: none !important;
      }
    `;
    
    // הרחבת התוכן לכל הרוחב - מוצא את כל הדיבים וממלא אותם
    const allContainers = document.querySelectorAll('body > div, main, [role="main"]');
    allContainers.forEach(container => {
      container.style.maxWidth = '100%';
      container.style.width = '100%';
      container.style.marginLeft = '0';
      container.style.marginRight = '0';
    });
    
    if (mainContainer) {
      mainContainer.style.marginRight = '0';
      mainContainer.style.marginLeft = '0';
      mainContainer.style.width = '100%';
      mainContainer.style.maxWidth = '100%';
    }
    if (mainContent) {
      mainContent.style.maxWidth = '100%';
      mainContent.style.width = '100%';
    }
  }
}

// המתנה לטעינת הדף ויצירת הכפתור
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', createToggleButton);
} else {
  createToggleButton();
}
